/*! rangeslider.js - v0.3.1 | (c) 2014 @andreruffert | MIT license | https://github.com/andreruffert/rangeslider.js */
"use strict";!function(a){"function"==typeof define&&define.amd?define(["jquery"],a):a("object"==typeof exports?require("jquery"):jQuery)}(function(a){function b(){var a=document.createElement("input");return a.setAttribute("type","range"),"text"!==a.type}function c(a,b){var c=Array.prototype.slice.call(arguments,2);return setTimeout(function(){return a.apply(null,c)},b)}function d(a,b){return b=b||100,function(){if(!a.debouncing){var c=Array.prototype.slice.apply(arguments);a.lastReturnVal=a.apply(window,c),a.debouncing=!0}return clearTimeout(a.debounceTimeout),a.debounceTimeout=setTimeout(function(){a.debouncing=!1},b),a.lastReturnVal}}function e(b,e){if(this.$window=a(window),this.$document=a(document),this.$element=a(b),this.options=a.extend({},i,e),this._defaults=i,this._name=f,this.startEvent=this.options.startEvent.join("."+f+" ")+"."+f,this.moveEvent=this.options.moveEvent.join("."+f+" ")+"."+f,this.endEvent=this.options.endEvent.join("."+f+" ")+"."+f,this.polyfill=this.options.polyfill,this.onInit=this.options.onInit,this.onSlide=this.options.onSlide,this.onSlideEnd=this.options.onSlideEnd,this.polyfill&&h)return!1;this.identifier="js-"+f+"-"+ +new Date,this.min=parseFloat(this.$element[0].getAttribute("min")||0),this.max=parseFloat(this.$element[0].getAttribute("max")||100),this.value=parseFloat(this.$element[0].value||this.min+(this.max-this.min)/2),this.step=parseFloat(this.$element[0].getAttribute("step")||1),this.$fill=a('<div class="'+this.options.fillClass+'" />'),this.$handle=a('<div class="'+this.options.handleClass+'" />'),this.$range=a('<div class="'+this.options.rangeClass+'" id="'+this.identifier+'" />').insertAfter(this.$element).prepend(this.$fill,this.$handle),this.$element.css({position:"absolute",width:"1px",height:"1px",overflow:"hidden",opacity:"0"}),this.handleDown=a.proxy(this.handleDown,this),this.handleMove=a.proxy(this.handleMove,this),this.handleEnd=a.proxy(this.handleEnd,this),this.init();var g=this;this.$window.on("resize."+f,d(function(){c(function(){g.update()},300)},20)),this.$document.on(this.startEvent,"#"+this.identifier+":not(."+this.options.disabledClass+")",this.handleDown),this.$element.on("change."+f,function(a,b){if(!b||b.origin!==f){var c=a.target.value,d=g.getPositionFromValue(c);g.setPosition(d)}})}var f="rangeslider",g=[],h=b(),i={polyfill:!0,rangeClass:"rangeslider",disabledClass:"rangeslider--disabled",fillClass:"rangeslider__fill",handleClass:"rangeslider__handle",startEvent:["mousedown","touchstart","pointerdown"],moveEvent:["mousemove","touchmove","pointermove"],endEvent:["mouseup","touchend","pointerup"]};e.prototype.init=function(){this.onInit&&"function"==typeof this.onInit&&this.onInit(),this.update()},e.prototype.update=function(){this.handleWidth=this.$handle[0].offsetWidth,this.rangeWidth=this.$range[0].offsetWidth,this.maxHandleX=this.rangeWidth-this.handleWidth,this.grabX=this.handleWidth/2,this.position=this.getPositionFromValue(this.value),this.$element[0].disabled?this.$range.addClass(this.options.disabledClass):this.$range.removeClass(this.options.disabledClass),this.setPosition(this.position)},e.prototype.handleDown=function(a){if(a.preventDefault(),this.$document.on(this.moveEvent,this.handleMove),this.$document.on(this.endEvent,this.handleEnd),!((" "+a.target.className+" ").replace(/[\n\t]/g," ").indexOf(this.options.handleClass)>-1)){var b=this.getRelativePosition(this.$range[0],a),c=this.getPositionFromNode(this.$handle[0])-this.getPositionFromNode(this.$range[0]);this.setPosition(b-this.grabX),b>=c&&b<c+this.handleWidth&&(this.grabX=b-c)}},e.prototype.handleMove=function(a){a.preventDefault();var b=this.getRelativePosition(this.$range[0],a);this.setPosition(b-this.grabX)},e.prototype.handleEnd=function(a){a.preventDefault(),this.$document.off(this.moveEvent,this.handleMove),this.$document.off(this.endEvent,this.handleEnd);var b=this.getRelativePosition(this.$range[0],a);this.onSlideEnd&&"function"==typeof this.onSlideEnd&&this.onSlideEnd(b-this.grabX,this.value)},e.prototype.cap=function(a,b,c){return b>a?b:a>c?c:a},e.prototype.setPosition=function(a){var b,c;b=this.getValueFromPosition(this.cap(a,0,this.maxHandleX))/this.step*this.step,c=this.getPositionFromValue(b),this.$fill[0].style.width=c+this.grabX+"px",this.$handle[0].style.left=c+"px",this.setValue(b),this.position=c,this.value=b,this.onSlide&&"function"==typeof this.onSlide&&this.onSlide(c,b)},e.prototype.getPositionFromNode=function(a){for(var b=0;null!==a;)b+=a.offsetLeft,a=a.offsetParent;return b},e.prototype.getRelativePosition=function(a,b){return(b.pageX||b.originalEvent.clientX||b.originalEvent.touches[0].clientX||b.currentPoint.x)-this.getPositionFromNode(a)},e.prototype.getPositionFromValue=function(a){var b,c;return b=(a-this.min)/(this.max-this.min),c=b*this.maxHandleX},e.prototype.getValueFromPosition=function(a){var b,c;return b=a/(this.maxHandleX||1),c=this.step*Math.ceil((b*(this.max-this.min)+this.min)/this.step),Number(c.toFixed(2))},e.prototype.setValue=function(a){a!==this.value&&this.$element.val(a).trigger("change",{origin:f})},e.prototype.destroy=function(){this.$document.off(this.startEvent,"#"+this.identifier,this.handleDown),this.$element.off("."+f).removeAttr("style").removeData("plugin_"+f),this.$range&&this.$range.length&&this.$range[0].parentNode.removeChild(this.$range[0]),g.splice(g.indexOf(this.$element[0]),1),g.length||this.$window.off("."+f)},a.fn[f]=function(b){return this.each(function(){var c=a(this),d=c.data("plugin_"+f);d||(c.data("plugin_"+f,d=new e(this,b)),g.push(this)),"string"==typeof b&&d[b]()})}});