<?php
/**
 * Additional functions
 *
 * @package Airi
 */

/**
 * Woocommerce - number of products
 */
function airi_woocommerce_products_number() {

    $number  = get_theme_mod( 'airi_archives_products_no', '9' );

    return $number;
}
add_filter( 'loop_shop_per_page', 'airi_woocommerce_products_number', 20 );


/**
 * Dynamic styles
 */
function airi_dynamic_styles($custom) {

	$custom = '';

	//Get settings
	$hide_product_price 	= get_theme_mod( 'airi_hide_product_price', 0 );
	$hide_product_rating 	= get_theme_mod( 'airi_hide_product_ratings', 0 );
	$hide_product_sorting 	= get_theme_mod( 'airi_hide_product_sorting', 0 );
	$hide_results_no 		= get_theme_mod( 'airi_hide_results_number', 0 );
	$hide_rating_single		= get_theme_mod( 'airi_hide_product_ratings_singles', 0 );

	if ( $hide_product_price ) {
		$custom .= ".post-type-archive-product.woocommerce .products .product .price {display:none;}"."\n";
	}
	if ( $hide_product_rating ) {
		$custom .= ".post-type-archive-product.woocommerce .products .product .star-rating {display:none;}"."\n";		
	}
	if ( $hide_product_sorting ) {
		$custom .= ".post-type-archive-product.woocommerce .woocommerce-ordering {display:none;}"."\n";		
	}
	if ( $hide_results_no ) {
		$custom .= ".post-type-archive-product.woocommerce .woocommerce-result-count {display:none;}"."\n";		
	}

	if ( $hide_rating_single ) {
		$custom .= ".woocommerce.single-product .product .woocommerce-product-rating {display:none;}"."\n";				
	}

	//Output all the styles
	wp_add_inline_style( 'airi-style', $custom );	
}
add_action( 'wp_enqueue_scripts', 'airi_dynamic_styles', 99 );