<?php

/**
 *
 * @link              http://athemes.com
 * @since             1.0
 * @package           Airi_Pro
 *
 * @wordpress-plugin
 * Plugin Name:       Airi Pro
 * Description:       Provides Elementor blocks and other enhancements for the Airi WordPress theme
 * Version:           1.0.3
 * Author:            aThemes
 * Author URI:        http://athemes.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       airi-toolbox
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

$theme  = wp_get_theme();
$parent = wp_get_theme()->parent();
if ( ($theme != 'Airi' ) && ($parent != 'Airi') )
    return;

/**
 * Set up and initialize
 */
class Airi_Pro {

	private static $instance;

	/**
	 * Returns the instance.
	 */
	public static function get_instance() {
		if ( ! self::$instance )
			self::$instance = new self;
		return self::$instance;
	}

	/**
	 * Actions setup
	 */
	public function __construct() {
		add_action( 'plugins_loaded', array( $this, 'constants' ), 2 );		
		add_action( 'elementor/widgets/widgets_registered', array( $this, 'widgets_registered' ) );
		add_action( 'elementor/elements/categories_registered', array( $this, 'block_category' ) );
		add_action( 'init', array( $this, 'includes' ), 9999 );
		add_action( 'elementor/frontend/after_register_scripts', array( $this, 'elementor_scripts' ), 4 );
		add_action( 'after_setup_theme', array( $this, 'demo_content' ) );
	}	

	/**
	 * Constants
	 */
	function constants() {

		define( 'AIRI_DIR', trailingslashit( plugin_dir_path( __FILE__ ) ) );
		define( 'AIRI_URI', trailingslashit( plugin_dir_url( __FILE__ ) ) );
	}	

	/**
	 * Load the Elementor custom blocks
	 */	
	public function widgets_registered() {

		if ( defined('ELEMENTOR_PATH') && class_exists('Elementor\Widget_Base') ) {

			require AIRI_DIR . '/blocks/block-shop-categories.php';
			require AIRI_DIR . '/blocks/block-portfolio.php';
			require AIRI_DIR . '/blocks/block-slider.php';
		}
	}

	/**
	 * Includes
	 */
	function includes() {

		//Customizer extra options
		require_once( AIRI_DIR . 'inc/customizer.php' );
		//Additional functions
		require_once( AIRI_DIR . 'inc/functions.php' );
		//Updates
		require_once( AIRI_DIR . 'updates.php' );
	}

	/**
	 * Demo content
	 */
	function demo_content() {
		require_once( AIRI_DIR . 'inc/demo-content.php' );
	}

	/**
	 * Scripts
	 */
	function elementor_scripts() {

		//Elementor scripts
		wp_enqueue_script( 'airi-elementor-scripts', AIRI_URI . '/js/elementor.js', array( 'jquery', 'jquery-slick' ), '20181010', true );
	}	

	/**
	 * Define an Elementor category for the custom blocks
	 */
	public function block_category() {
		\Elementor\Plugin::$instance->elements_manager->add_category( 
	   	'airi-elements',
	   	[
	   		'title' => __( 'Airi Elements', 'airi' ),
	   		'icon' => 'fa fa-plug',
	   	],
	   	1
		);		
	}
}

Airi_Pro::get_instance();



/**
 * Updates
 */
define( 'ATHEMES_STORE_URL', 'http://athemes.com' );
define( 'ATHEMES_PLUGIN_NAME', 'Airi Pro' );

if( !class_exists( 'EDD_SL_Plugin_Updater' ) ) {
    include( plugin_dir_path( __FILE__ ) . '/EDD_SL_Plugin_Updater.php' );
}

function airi_pro_plugin_updater() {
    $license_key = trim( get_option( 'airi_pro_license_key' ) );

    // setup the updater
    $edd_updater = new EDD_SL_Plugin_Updater( ATHEMES_STORE_URL, __FILE__, array(
            'version'   => '1.0.3',
            'license'   => $license_key,
            'item_name' => ATHEMES_PLUGIN_NAME,
            'author'    => 'aThemes'
        )
    );
}
add_action( 'admin_init', 'airi_pro_plugin_updater', 0 );