<?php

/**
 * Airi Theme Customizer
 *
 * @package Airi
 */


function airi_pro_modify_options( $wp_customize ) {

	$wp_customize->remove_section( 'airi_upsell' );

	//Additonal menu type choices
	$wp_customize->get_control( 'menu_type' )->choices =  array(
		'menuStyle1' => esc_attr__( 'Basic 1 - inside header', 'airi' ),
		'menuStyle2' => esc_attr__( 'Basic 2 - outside header', 'airi' ),
		'menuStyle5' => esc_attr__( 'Basic 3 - inside header', 'airi' ),
		'menuStyle6' => esc_attr__( 'Basic 4 - inside header', 'airi' ),
		//Pro menu styles
		'menuStyle3' => esc_attr__( 'Extended 1 - finance style', 'airi' ),
		'menuStyle4' => esc_attr__( 'Extended 2 - local business style', 'airi' ),
	);

	//Additional blog layout choices
	$wp_customize->get_control( 'blog_layout' )->choices =  array(
		'layout-default' 	=> esc_attr__( 'Default', 'airi' ),
		'layout-grid' 		=> esc_attr__( 'Grid', 'airi' ),
		'layout-list-2' 	=> esc_attr__( 'Classic', 'airi' ),
		'layout-two-columns'=> esc_attr__( 'Two Columns', 'airi' ),
		'layout-masonry' 	=> esc_attr__( 'Masonry', 'airi' ),
		'layout-list' 		=> esc_attr__( 'List', 'airi' ),
	);
}
add_action( 'customize_register', 'airi_pro_modify_options', 999 );

//Additional footer options
Airi_Kirki::add_field( 'airi', array(
	'type'       		=> 'image',
	'settings'    		=> 'footer_background_image',
	'label'       		=> __( 'Background image (footer widgets area)', 'airi' ),
	'section'     		=> 'airi_section_footer',
	'default'     		=> '',
	'transport'			=> 'auto',
    'output'      		=> array(
        array(
            'element'  => '.footer-widgets',
            'property' => 'background-image',
        ),
    ),		
) );
Airi_Kirki::add_field( 'airi', array(
	'type'        		=> 'text',
	'settings'    		=> 'footer_credits',
	'label'       		=> esc_attr__( 'Footer credits', 'airi' ),
	'section'    		=> 'airi_section_footer',
	'sanitize_callback' => 'airi_sanitize_text',
	'default'     		=> '',
	'priority'    		=> 10,
) );

//Woocommerce
Airi_Kirki::add_panel( 'airi_woocommerce_panel', array(
    'priority'    => 21,
    'title'       => esc_attr__( 'Airi Pro: WooCommerce', 'airi' ),
) );
//Single product
Airi_Kirki::add_section( 'airi_single_product', array(
    'title'          => esc_attr__( 'Single products', 'airi' ),
    'panel'          => 'airi_woocommerce_panel',
    'priority'       => 1,
) );
Airi_Kirki::add_field( 'airi', array(
	'type'        => 'checkbox',
	'settings'    => 'airi_hide_product_ratings_singles',
	'label'       => esc_attr__( 'Hide product rating on single products?', 'airi' ),
	'section'     => 'airi_single_product',
	'default'     => '0',
	'priority'    => 10,
) );

Airi_Kirki::add_field( 'airi', array(
	'type'     	  => 'slider',
	'settings'    => 'font_size_wc_product_title',
	'label'       =>  esc_attr__( 'Product title', 'airi' ),
	'section'     => 'airi_single_product',
	'default'     => '30',
	'priority'    => 10,
	'choices'   => array(
		'min'  => 10,
		'max'  => 60,
		'step' => 1,
	),
	'transport'	  => 'auto',
	'output'      => array(
		array(
			'element'  => '.woocommerce.single div.product .product_title',
			'property' => 'font-size',
			'units'    => 'px',
		),
	),	
) );
Airi_Kirki::add_field( 'airi', array(
	'type'     	  => 'slider',
	'settings'    => 'font_size_wc_product_price',
	'label'       =>  esc_attr__( 'Product price', 'airi' ),
	'section'     => 'airi_single_product',
	'default'     => '20',
	'priority'    => 10,
	'choices'   => array(
		'min'  => 10,
		'max'  => 36,
		'step' => 1,
	),
	'transport'	  => 'auto',
	'output'      => array(
		array(
			'element'  => '.woocommerce.single div.product .woocommerce-Price-amount',
			'property' => 'font-size',
			'units'    => 'px',
		),
	),	
) );

Airi_Kirki::add_section( 'airi_product_archives', array(
    'title'          => esc_attr__( 'Product archives', 'airi' ),
    'panel'          => 'airi_woocommerce_panel',
    'priority'       => 2,
) );
Airi_Kirki::add_field( 'airi', array(
	'type'        => 'number',
	'settings'    => 'airi_archives_products_no',
	'label'       => esc_attr__( 'Number of products on shop archives', 'airi' ),
	'section'     => 'airi_product_archives',
	'default'     => 9,
	'priority'    => 10,
	'choices'     => array(
		'min'  => 2,
		'max'  => 50,
		'step' => 1,
	),
) );
Airi_Kirki::add_field( 'airi', array(
	'type'        => 'checkbox',
	'settings'    => 'airi_hide_product_price',
	'label'       => esc_attr__( 'Hide product price?', 'airi' ),
	'section'     => 'airi_product_archives',
	'default'     => '0',
	'priority'    => 10,
) );
Airi_Kirki::add_field( 'airi', array(
	'type'        => 'checkbox',
	'settings'    => 'airi_hide_product_ratings',
	'label'       => esc_attr__( 'Hide product ratings?', 'airi' ),
	'section'     => 'airi_product_archives',
	'default'     => '0',
	'priority'    => 10,
) );
Airi_Kirki::add_field( 'airi', array(
	'type'        => 'checkbox',
	'settings'    => 'airi_hide_product_sorting',
	'label'       => esc_attr__( 'Hide sorting?', 'airi' ),
	'section'     => 'airi_product_archives',
	'default'     => '0',
	'priority'    => 10,
) );
Airi_Kirki::add_field( 'airi', array(
	'type'        => 'checkbox',
	'settings'    => 'airi_hide_results_number',
	'label'       => esc_attr__( 'Hide number of results?', 'airi' ),
	'section'     => 'airi_product_archives',
	'default'     => '0',
	'priority'    => 10,
) );

Airi_Kirki::add_field( 'airi', array(
	'type'     	  => 'slider',
	'settings'    => 'font_size_wc_archive_product_title',
	'label'       =>  esc_attr__( 'Product title', 'airi' ),
	'section'     => 'airi_product_archives',
	'default'     => '16',
	'priority'    => 10,
	'choices'   => array(
		'min'  => 10,
		'max'  => 60,
		'step' => 1,
	),
	'transport'	  => 'auto',
	'output'      => array(
		array(
			'element'  => '.woocommerce.post-type-archive .products li.product .woocommerce-loop-product__title',
			'property' => 'font-size',
			'units'    => 'px',
		),
	),	
) );
Airi_Kirki::add_field( 'airi', array(
	'type'     	  => 'slider',
	'settings'    => 'font_size_wc_archive_product_price',
	'label'       =>  esc_attr__( 'Product price', 'airi' ),
	'section'     => 'airi_product_archives',
	'default'     => '16',
	'priority'    => 10,
	'choices'   => array(
		'min'  => 10,
		'max'  => 36,
		'step' => 1,
	),
	'transport'	  => 'auto',
	'output'      => array(
		array(
			'element'  => '.woocommerce.post-type-archive .woocommerce-Price-amount',
			'property' => 'font-size',
			'units'    => 'px',
		),
	),	
) );